<?php
// app/Controllers/SupplierController.php
namespace App\Controllers;

use App\Core\Controller;
use App\Core\Database;
use App\Models\SupplierRepository;

class CustomerController extends Controller
{
    private CustomerRepository $repo;

    public function __construct(Database $db)
    {
        parent::__construct();
        $this->repo = new CustomerRepository($db);
    }

    public function index()
    {
        // vrací CustomerEntity[]
        $items = $this->repo->findAll();
        $this->view->render('customers/index', ['customers' => $items]);
    }

    public function create()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = $this->validate($_POST);
            $this->repo->create($data);
            $this->redirect('?controller=customer&action=index');
        }
        $this->view->render('customers/form');
    }

    public function edit()
    {
        $id = (int)($_GET['id'] ?? 0);
        $customer = $this->repo->find($id);
        if (!$customer) {
            http_response_code(404);
            echo 'Zákazník nenalezen';
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = $this->validate($_POST);
            $this->repo->update($id, $data);
            $this->redirect('?controller=customer&action=index');
        }

        $this->view->render('customers/edit', ['customer' => $customer]);
    }

    public function delete()
    {
        $id = (int)($_GET['id'] ?? 0);
        $this->repo->delete($id);
        $this->redirect('?controller=customer&action=index');
    }

    public function show()
    {
        $id = (int)($_GET['id'] ?? 0);
        $customer = $this->repo->find($id);
        if (!$customer) {
            http_response_code(404);
            echo 'Zákazník nenalezen';
            exit;
        }
        $this->view->render('customers/show', ['customer' => $customer]);
    }

    /**
     * Základní validace vstupu z formuláře.
     * Vrací pole připravené pro repository (create/update).
     */
    private function validate(array $input): array
    {
        return [
            'name'  => trim($input['name'] ?? ''),
            'email' => trim($input['email'] ?? ''),
            'phone' => trim($input['phone'] ?? '')
        ];
    }
}